<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Versement extends Model 
{

    protected $table = 'versements';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'evenement_id', 'prix', 'mois_avant', 'mois_apres', 'admin_forme', 'ceremonie_max', 'invite_max', 'photo_max', 'cagnotte_max', 'domaine', 'statut');
    protected $visible = array('evenement_id', 'prix', 'mois_avant', 'mois_apres', 'admin_forme', 'ceremonie_max', 'invite_max', 'photo_max', 'cagnotte_max', 'domaine', 'statut');

    public function evenement()
    {
        return $this->belongsTo('App\Models\Evenement', 'evenement_id');
    }

}